// XISLPrompt.cpp: CXISLPrompt NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLPrompt.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLPrompt::CXISLPrompt(int Count)
{
	m_Count.Format("%d",Count);
	m_TimeOut="0";
	m_BargeIn=FALSE;
	m_nTagType=ID_TAG_PROMPT;
	m_nBmpID =IDB_PROMPT;
	m_pXISLAct = new CXISLActTag(this,FALSE);
}

CXISLPrompt::~CXISLPrompt()
{
	if(m_pXISLAct!=NULL)
		delete m_pXISLAct;
}

//LPCTSTR CXISLPrompt::CXISLPrompt::GetXISLString()
//@\@FpromptȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLPrompt::GetXISLString()
{
	m_strXISL.Empty();
	m_strXISL = "<prompt count = \"";
	m_strXISL += m_Count;
	if(m_StateTimeOut==TRUE){
		m_strXISL += "\" timeout = \"";
		m_strXISL += m_TimeOut;
	}
	m_strXISL += "\" bargein = \"";
	if(m_BargeIn==TRUE)
		m_strXISL += "true";
	else if(m_BargeIn==FALSE)
		m_strXISL += "false";
	m_strXISL += "\">\r\n";
	if(m_pXISLAct!=NULL)
		m_strXISL += m_pXISLAct->GetXISLString();
	m_strXISL += "</prompt>\r\n";
	return m_strXISL;
}

//int CXISLPrompt::GetItemCount()
//@\@FbeginȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLPrompt::GetItemCount()
{
	int nCount;
	nCount = m_pXISLAct->GetItemCount();
	nCount++; //<exchange>̕
	return nCount;
}

//BOOL CXISLPrompt::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLPrompt::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[m_nTagType];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	m_pXISLAct->RegistXISLTree(pTree,hParent);

	return TRUE;
}

void CXISLPrompt::InsertActItem(CXISLActItem *pTag)
{
	m_pXISLAct->InsertActItem(pTag);
}

//폜
//2003/6/5@
void CXISLPrompt::DeleteAllAct()
{
	CXISLTag *pTag;
	while(m_pXISLAct->m_ActionList.IsEmpty() == FALSE){
		pTag = (CXISLTag*)(m_pXISLAct->m_ActionList.GetHead());
		m_pXISLAct->DeleteActItem((CXISLActItem *)pTag);
	}
}

//CSize CXISLPrompt::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Faction̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLPrompt::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;
	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);

	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);
	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;

	pDC->MoveTo(nX,nY);
	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	int nBX = nX;
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);

	int nMaxX = nX;
	if(m_pXISLAct)
	{
		CSize sizeAct = m_pXISLAct->DrawXISLFlow(pDC,nX,nY);
		if(nMaxX < sizeAct.cx)
			nMaxX = sizeAct.cx;
		nY = sizeAct.cy;
	}

	if(m_pXISLAct->m_ActionList.GetCount() == 0)
	{
		pDC->MoveTo(nBX+4,nY-6);
		pDC->LineTo(nBX,nY);
		pDC->MoveTo(nBX-4,nY-6);
		pDC->LineTo(nBX,nY);
	}
	nViewSizeX = nMaxX;
	nViewSizeY = nY;
	MemDC.SelectObject(pOldBMP);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nX,nY);
}

//CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLPrompt::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		if(m_pXISLAct)
		{
			pTag = m_pXISLAct->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}